unit FormOsoby;

interface

uses
  Windows, Messages, Classes, SysUtils, Graphics, Controls, StdCtrls, Forms,
  Dialogs, DBCtrls, DB, DBGrids, Grids, ExtCtrls, ActnList, Buttons;

type
  TFOsoby = class(TForm)
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    Panel2: TPanel;
    btnClose: TSpeedButton;
    btnInsert: TSpeedButton;
    btnEdit: TSpeedButton;
    btnDelete: TSpeedButton;
    ActionList1: TActionList;
    ActionClose: TAction;
    ActionInsert: TAction;
    ActionEdit: TAction;
    ActionDelete: TAction;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure ActionCloseExecute(Sender: TObject);
    procedure ActionEditExecute(Sender: TObject);
    procedure DBGrid1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure ActionInsertExecute(Sender: TObject);
    procedure ActionDeleteExecute(Sender: TObject);

  private
	 procedure  My_insert();

  public
    procedure  My_edit();
    procedure  My_delete();
    function   Daj_max_id() : Integer;
    procedure  My_insert2();
	 procedure  Ustaw_sie_na_nowym_rekordzie(idosoby : Integer);

    procedure  ustaw_sie_na_nowym_rek(idosoby: Integer);
  end;

var
  FOsoby: TFOsoby;

implementation
{$R *.DFM}

uses
   DataModule, DialogOsoba;

procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
   DM.TableOsoby.Close();
   DM.QueryOsoby.Close();
   
   FOsoby := NIL;
end;

procedure TFOsoby.FormShow(Sender: TObject);
begin
   Position := poDefault;
   Top      := 60;
   Left     := 0;
   Width    := Screen.Width;
   Height   := Screen.Height - 100;

   DM.QueryOsoby.Open();
   DM.TableOsoby.Open();

   DBGrid1.DataSource := DM.dsQuery;
end;

procedure TFOsoby.ActionCloseExecute(Sender: TObject);
begin
   Close();
end;

procedure TFOsoby.ActionEditExecute(Sender: TObject);
begin
   My_edit();
end;

procedure TFOsoby.DBGrid1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if key = VK_RETURN then begin
      My_edit();
   end;

   if key = VK_INSERT then begin
      My_insert2();
   end;

   if key = VK_DELETE then begin
      My_delete();
   end;
end;

procedure TFOsoby.DBGrid1DblClick(Sender: TObject);
begin
   my_edit();
end;

procedure TFOsoby.ActionInsertExecute(Sender: TObject);
begin
   My_insert2();
end;

procedure TFOsoby.ActionDeleteExecute(Sender: TObject);
begin
   my_delete();
end;

procedure TFOsoby.My_edit();
var
   Res      : TModalResult;
   zakladka : TBookMark;

begin
   if DM.QueryOsoby.RecordCount = 0 then begin
      EXIT;
   end;

   zakladka := DM.QueryOsoby.GetBookmark();
   try
      DlgOsoba := TDlgOsoba.Create(Self);

      DM.TableOsoby.MasterSource := DM.dsQuery;
      DM.TableOsoby.MasterFields := 'IDOSOBY';
      DM.TableOsoby.Open();

      res := DlgOsoba.ShowModal();
      if res = mrOK then begin
         DM.QueryOsoby.Close();
         DM.QueryOsoby.Open();
         DM.QueryOsoby.GotoBookmark(zakladka);
      end;
   finally
      DM.QueryOsoby.FreeBookmark(zakladka);
      DM.TableOsoby.Close();
      FreeAndNil(DlgOsoba);
   end;
end;

procedure TFOsoby.ustaw_sie_na_nowym_rek(idosoby: Integer);
var
   wykonuj : Boolean;
   id      : Integer;
begin
   DM.QueryOsoby.First();

   wykonuj := True;

   DM.QueryOsoby.DisableControls();

   while Wykonuj do begin
      if DM.QueryOsoby.EOF then begin
         Wykonuj := False;
         Continue;
      end;

      id := DM.QueryOsoby.FieldByName('IDOSOBY').AsInteger;

      if id = idosoby then begin
         Wykonuj := False;
         Continue;
      end;

      DM.QueryOsoby.Next();
   end;

   DM.QueryOsoby.EnableControls();
end;

procedure TFOsoby.my_delete();
var
   id : Integer;

begin
   if DM.QueryOsoby.RecordCount = 0 then begin
      EXIT;
   end;
   
   if MessageBox(0, PChar('Usun rekord ?'), 'Ostrzeenie', MB_YESNO ) = IDYES then begin
      id := DM.QueryOsoby.FieldByName('IDOSOBY').AsInteger;

      with DM.QueryOsoby do begin
         Close();

         SQL.Clear();
         SQL.Add('delete from OSOBY ');
         SQL.Add('where IDOSOBY = :IDOSOBY');
         ParamByName('IDOSOBY').AsInteger := Id;

         try
            ExecSQL();
         finally
            Close();
         end;
      end;

      // odwieam ekran i przywracam poprzedni zawarto
      // polecenia SQL
      with DM.QueryOsoby do begin
         Close();

         SQL.Clear();
         SQL.Add('select * from OSOBY');
         SQL.Add('order by NAZWISKO, IMIE');

         Open();
      end;
   end;
end;

procedure TFOsoby.My_insert();
var
   recs : Integer;
   Res  : TModalResult;

begin
   if DM.QueryOsoby.RecordCount = 0 then begin
      EXIT;
   end
   else begin
      recs := DM.QueryOsoby.RecordCount;
      // jeeli numeracja IDOSOBY zaczyna sie od jeden wwczas Inc(recs);
      // jeeli tak jak u mnie zaczyna si od zera to recs pozotsje bez zmian
   end;

   try
      DlgOsoba := TDlgOsoba.Create(Self);

      DM.TableOsoby.Open();
      DM.TableOsoby.Append();
      DM.TableOsobyIDOSOBY.Value := recs;

      res := DlgOsoba.ShowModal();

      if res = mrOK then begin
         DM.QueryOsoby.Close();
         DM.QueryOsoby.Open();

         ustaw_sie_na_nowym_rek(recs);
      end;
   finally
      DM.TableOsoby.Close();
      FreeAndNil(DlgOsoba);
   end;
end;

function TFOsoby.Daj_max_id() : Integer;
var
	ret : Integer;

begin
	ret := -1;

   DM.TableOsoby.Close();
   DM.TableOsoby.MasterSource    := Nil;
   DM.TableOsoby.MasterFields    := '';
   DM.TableOsoby.IndexFieldNames := 'IDOSOBY';
   DM.TableOsoby.Open();
   DM.TableOsoby.Last();
   ret := DM.TableOsoby.FieldByName('IDOSOBY').AsInteger;

   DM.TableOsoby.Close();

   Result := ret;
end;

procedure TFOsoby.My_insert2();
var
   recs : Integer;
   res  : TMOdalResult;

begin
	recs := 0;

   recs := Daj_max_id();
   Inc(recs);

   try
      DlgOsoba := TDlgOsoba.Create(Self);

      DM.TableOsoby.Open();
      DM.TableOsoby.Append();
      DM.TableOsobyIDOSOBY.Value := recs;

      res := DlgOsoba.ShowModal();
   finally
      DM.TableOsoby.Close();

      DM.QueryOsoby.Close();
      DM.QueryOsoby.Open();

      Ustaw_sie_na_nowym_rekordzie(recs);

   	FreeAndNil(DlgOsoba);
   end;
end;

procedure TFOsoby.Ustaw_sie_na_nowym_rekordzie(idosoby: Integer);
begin
   DM.QueryOsoby.DisableControls();

   while not DM.QueryOsoby.Eof do
   begin
   	if DM.QueryOsoby.FieldByName('IDOSOBY').AsInteger = idosoby then
      begin
         break;
      end;
		DM.QueryOsoby.Next();
   end;

   DM.QueryOsoby.EnableControls();
end;

end.
